//AC130-Script by LurchiDerLurch uav_rot_setup

private ["_plane","_pos","_radius","_height","_sequence", "_delay"];

_input = _this select 0;
_radius = _this select 1;
_height = _this select 2;
_sequence = _this select 3;
_delay = _this select 4;

waitUntil{(!LDL_ac130_active)};

LDL_ac130_active = true;
LDL_plane_type = "UAV";

if (typeName _input == "ARRAY") then
{
	if(_delay > 0) then
	{
		[_delay, "UAV available:"]call LDL_ac130_delay;
	};
	
	_pos = _input;
	LDL_cam_rotating_center setPos _pos;
	LDL_ac130_plane = createVehicle ["MQ9PredatorB",[0,0,1000], [], 0, "FLY"];
	_ac130_pilot = "USMC_Soldier_Pilot" createUnit [getPos player,createGroup WEST,"LDL_ac130_pilot = this; this moveInDriver LDL_ac130_plane;", 0.6, "corporal"];
	
	//delete
	[LDL_ac130_plane]spawn
	{
		_plane = _this select 0;
		waitUntil{sleep 1;(!LDL_ac130_active)};
		deleteVehicle _plane;
		deleteVehicle LDL_ac130_pilot;
	};
	
	[_radius,_height] call LDL_setVariables;
	LDL_view360 = true;

	[LDL_ac130_plane, LDL_cam_rotating_center, LDL_cam_rotating_radius, LDL_cam_rotating_angle, LDL_cam_rotating_height]call LDL_setCirclePosition;
	
	LDL_ac130_plane setDir (LDL_cam_rotating_angle - 90);
};
	
if (typeName _input == "OBJECT") then
{
	LDL_ac130_plane = _input;
	
	//fly
	[LDL_ac130_plane]spawn
	{
		_plane = _this select 0;
		waitUntil{sleep 1;(!LDL_ac130_active)};
		_plane enableSimulation true;
		_vel = [sin(getDir LDL_ac130_plane)*200,cos(getDir _plane)*200,0];
		_plane setVelocity _vel;
	};

	[_radius,_height] call LDL_setVariables;
	LDL_view360 = true;
	
	_pos = LDL_ac130_plane modelToWorld [_radius*-1,0,0];
	
	LDL_cam_rotating_center setPos [_pos select 0,_pos select 1,0];
	LDL_cam_rotating_height = getPosASL LDL_ac130_plane select 2; //TODO: take the height from the call argument
	LDL_cam_rotating_angle = [(getDir LDL_ac130_plane) + 90]call LDL_normalizeAngle;
	LDL_cam_dirh = [LDL_cam_rotating_angle-180]call LDL_normalizeAngle;
};

if(_sequence) then
{
	[getPos player]call LDL_camera_approach;
};

LDL_ac130_plane engineOn true;

if(!_enablePhysics) then
{
	[]spawn 
	{
		sleep 3;
		LDL_ac130_plane enableSimulation false;
	};
};

LDL_flyMode = 1;

//Create the dialog
[]call LDL_uav_createDialog;

//Create the cam
LDL_ac130_cam = []call LDL_createCam;

//Start all scripts
[]spawn LDL_ac130_rot_camera;
[]spawn LDL_uav_rot_main;
[]spawn LDL_ac130_blink;
[]spawn LDL_ac130_troops;
[]spawn LDL_ac130_sound;
[]spawn LDL_ac130_rot_waypoints;