/*	ac130_calculateBullet.sqf for AC130-Script
*	@author: LurchiDerLurch
*	@param: nothing
*	@return: nothing
*	@description: 
*/

//local variables
private["_dirh","_dirv","_weapon","_position","_spread", "_r_sphere", "_z", "_x", "_y", "_shell", "_vel"];

_dirh = _this select 0;
_dirv = _this select 1;
_weapon = _this select 2;
_position = _this select 3;

if(LDL_plane_type == "AC130_AI") then
{
	_spread = 0;
}
else
{
	_spread = (random 100)/500;
};

_dirh = _dirh + sin(random 360)*_spread;
_dirv = _dirv + cos(random 360)*_spread;

_r_sphere = 100;
_z = _r_sphere* cos(_dirv - 90);	
_r = sqrt(_r_sphere^2 - _z^2);
_x = sin(_dirh)*_r;
_y = cos(_dirh)*_r;

//Create shell
_shell = (LDL_ammo select _weapon) createVehicle _position;
_shell setPos _position;

switch (_weapon) do
{
	case 0:
	{
		if (LDL_Ammo25 > 0) then
		{
			//Velocity
			_vel = [_x * 30,_y * 30,_z * 30];
			
			//Ammo
			LDL_Ammo25 = LDL_Ammo25 - 1;
			
			//Sound
			LDL_PublicLDLCannon25Sound = LDL_ac130_plane;
			publicVariable "LDL_PublicLDLCannon25Sound";
			LDL_ac130_plane say ["LDL_gun01",1];
			
			//Particles
			#include "ac130_createParticleSource.sqf"
			LDL_PublicLDLCannon25FX = [_shell, _vel, _weapon, _position];
			publicVariable "LDL_PublicLDLCannon25FX";
			
			//Spread
			while {alive _shell} do
			{
				if(LDL_plane_type != "AC130_AI") then
				{
					 _x = sin(random 360)*0.2;
					 _y = sin(random 360)*0.2;
					 _z = sin(random 360)*0.2;
					 _shell setPos (_shell modelToWorld[_x,_y,_z]);
				};

				 sleep 0.1;
				 
				 _shell setVelocity _vel;
			};
		};
	};
	
	case 1:
	{
		if (LDL_Ammo40 > 0) then
		{
			//Velocity
			_vel = [_x *20,_y * 20,_z * 20];
			
			//Ammo
			LDL_Ammo40 = LDL_Ammo40 - 1;
			
			//Sound
			LDL_PublicLDLCannon40Sound = LDL_ac130_plane;
			publicVariable "LDL_PublicLDLCannon40Sound";
			LDL_ac130_plane say ["LDL_gun02",1];
			
			//Particles
			#include "ac130_createParticleSource.sqf"
			LDL_PublicLDLCannon40FX = [_shell, _vel, _weapon, _position];
			publicVariable "LDL_PublicLDLCannon40FX";
			
			//Spread
			while {alive _shell} do
			{
				if(LDL_plane_type != "AC130_AI") then
				{
					 _x = sin(random 360)*0.5;
					 _y = sin(random 360)*0.5;
					 _z = sin(random 360)*0.5;
					 _shell setPos (_shell modelToWorld[_x,_y,_z]);
				};

				 sleep 0.1;
				 
				 _shell setVelocity _vel;
			};
		};
	};
	
	case 2:
	{
		if (LDL_Ammo105 > 0) then
		{
			//Velocity
			_vel = [_x * 20,_y * 20,_z * 20];
			
			//Ammo
			LDL_Ammo105 = LDL_Ammo105 - 1;
			
			//Sound
			LDL_PublicLDLCannon105Sound = LDL_ac130_plane;
			publicVariable "LDL_PublicLDLCannon105Sound";
			LDL_ac130_plane say ["LDL_gun03",1];
			
			//Particles
			#include "ac130_createParticleSource.sqf"
			LDL_PublicLDLCannon105FX = [_shell, _vel, _weapon, _position];
			publicVariable "LDL_PublicLDLCannon105FX";
			
			//Spread
			while {alive _shell} do
			{
				 sleep 0.1;
				 _shell setVelocity _vel;
			};
		};
	};
};