/*
Function: ECHO_fnc_TargetETA

Description:
   Estimate time to target.

Parameters:
   Battery - An Artillery Module. [Object]

   Position - Location ASL to fire at. [Pos3d]

   Ordnance Type - "HE", "SMOKE", "ILLUM", "WP", "SADARM", "LASER"

Returns:
   Time - Travel time in seconds [Float]

Example:
   (begin example)
      _flight_time = [ABattery, getPosASL _thisTarget, "HE"] call ECHO_fnc_TargetETA.sqf;
   (end)

Author:
 Evil_Echo

Copyright: 2010
 */

private[
	"_Battery",
	"_Coords",
	"_Ord_Type",
	"_Time",
	"_success",
	"_battery_scope",
	"_battery_leader",
	"_battery_location",
        "_gun_type",
	"_mag_type",
	"_ballistics",
	"_solution"
];

_Battery  = _this select 0;
_Coords   = _this select 1;
_Ord_Type = _this select 2;

_Time = -1;
_Success = true;

if ( isNull _Battery ) then {
	_success = false;
};

if ( _success ) then {
	_battery_scope = [_Battery] call BIS_ARTY_F_GetScope;
	_battery_leader = _battery_scope call BIS_ARTY_F_BatteryLead;
	_battery_location = getPosASL _battery_leader;
	_gun_type = _battery_leader call BIS_ARTY_F_GetWeaponType;
	_mag_type = [_gun_type, _Ord_Type] call BIS_ARTY_F_GetMagazineFromOrdAndWeaponType;
	_ballistics = _mag_type call BIS_ARTY_F_GetBallisticsCatEntry;

	if ( (count _ballistics) == 0 ) then {
	    _ballistics = _battery_scope getVariable "ARTY_BALLISTICS_TABLE";
	};

	_solution = [_battery_location, _Coords, _ballistics] call BIS_ARTY_F_FiringSolution;

	if ( (count _solution) >= 2 ) then {
		_Time = _solution select 2;
	};
};

sam_time_of_flight = _time;
