@echo off
rem check that addons dir and the vte files exist.
if not exist addons\*.pbo goto err

rem check if xdelta3 binary files existin the root dir.
if not exist xdelta3\xdelta3_*.pbo goto err

rem check if _pbo_list.txt is present
if not exist _pbo_list.txt goto err

rem check if xdelta3.exe is present
if not exist xdelta3.exe goto xdelta3err

echo All VTE*.pbo files present, proceeding xdelta3 patching!

rem start patching
for /F %%a in (_pbo_list.txt) do (
echo Patching %%a ...
xdelta3 -f -d -s addons\%%a xdelta3\xdelta3_%%a new_%%a > nul
move new_%%a addons\%%a >nul
)
copy xdelta3\*.bisign addons\ >nul

rem delete xdelta3\ dir contents
echo Deleting xdelta3\ directory...
del /Q xdelta3

rem delete xdelta3\ dir
rd xdelta3

rem delete _pbo_list.txt file
del _pbo_list.txt

echo All done, VTE has been patched to latest version :)
pause
exit

rem we didn't find some of the pbo or xdelta files, so we exit.
:err
echo Something went wrong, some or all VTE*.pbo and/or xdelta3 binary files were missing!
echo Please consult the enclosed readme for install instructions.
pause
exit

:xdelta3err
echo xdelta3.exe file is not present in this directory, cannot continue!
echo please read readme.txt for more details.
pause
exit
