// MIG-29 Fulcrum v1.0 by Scorpio


// some basic defines
#define TEast 0
#define TWest 1
#define TGuerrila 2
#define TCivilian 3
#define TSideUnknown 4
#define TEnemy 5
#define TFriendly 6
#define TLogic 7

#define true 1
#define false 0

// type scope
#define private 0
#define protected 1
#define public 2

class CfgPatches
{
	class MIG29_Fulcrum
	{
		units[] = {MIG29_Fulcrum};
		weapons[] = {MIG29_AA8a_Aphid,GSchI30_Bullet};
		requiredVersion = 1.30;
	};
};


class CfgAmmo
{
	class Default {};
	class AT3: Default {};
	class CarlGustav: AT3 {};
 	class AA : CarlGustav {};
	class MIG29_AA8a_Aphid : AA
	{

		
                minRange=100;			
       	 	minRangeProbab=0.30;		
        	midRange=500;			
        	midRangeProbab=0.60;		
        	maxRange=2000;			
        	maxRangeProbab=0.3;		
		airLock=1;
		irLock=0;
		initTime=0.4;//0.1
		ThrustTime=15;//1.5
		thrust=1000;
		maxspeed=900;
                hit=100;indirectHit=80;indirectHitRange=3;
		model = "\SPC_MIG\MIG29_AA8a_Aphid";
		proxyShape = "\SPC_MIG\MIG29_AA8a_Aphid";
		manualControl=false; // true
		maxControlRange=10000;
		maneuvrability=65.0;
	};

	class BulletSingle: default {};
	class ExplosiveBullet: BulletSingle {};
	class Bullet30: ExplosiveBullet {};

	class GSchI30_Bullet: Bullet30
	{
		hit=40;
		indirectHit=10;
   		indirectHitRange=1;
		explosive=0;		
	};
};

class CfgWeapons
{
	class Default {};
	class LAWLauncher: Default {};
	class CarlGustavLauncher : LAWLauncher {};
	class AT3Launcher: CarlGustavLauncher {};
	class HellfireLauncher: AT3Launcher {};
	class MaverickLauncher: HellfireLauncher {};
	class ZuniLauncher38: AT3Launcher {};
	class kab500_mig : ZuniLauncher38
	{
		displayName="KAB-500KR";
		displayNameMagazine="KAB-500KR";
		shortNameMagazine="KAB-500KR";
		opticsZoomMin=0.08;
		opticsZoomMax=0.84;
		count=64;
		reloadTime=0.15;
		optics=1;
		maxLeadSpeed=2300;
		flashSize=0;
		sound[]={Weapons\rocket1,db+60,1};
		
	};
	class MIG29_AA8a_Aphid: MaverickLauncher
	{
		
		ammo=MIG29_AA8a_Aphid;
		displayName="AA8a_Aphid";
		displayNameMagazine="AA8a_Aphid";
		shortNameMagazine="AA8a";
		count=8;				//6-0 or 4-2
		initspeed=0;	
		model="\SPC_MIG\MIG29_AA8a_Aphid.p3d";
		canLock=2;		
		sound[]={"\SPC_MIG\MIG-29_Outside_AA10_launch.ogg",db+40,0.6};
		aiRateOfFire=12.000000;
		aiRateOfFireDistance=5000;
	};

	class MGun: Default {};
	class MachineGun7_6: MGun {};
	class MachineGun30: MachineGun7_6 {};

	class MIG29_30mm: MachineGun30
	{
		dispersion=0.00100;
		displayName="30mm GSchI";
		displayNameMagazine="30mm GSchI";
		shortNameMagazine="30mm GSchI";
		ammo="GSchI30_Bullet";
		count=300;				//150
		initSpeed=860;
   		sound[]={"Weapons\automatic_cannon",3.162278,1};
		reloadTime=0.075;
      		multiplier=1;
      		burst=3;
		soundContinuous=1;
		flashSize=0.000000;
		maxLeadSpeed=1800;
		optics=1;
	};

	
};


class CfgVehicles
{
	class All {};
	class AllVehicles: All {};
	class Air: AllVehicles {};
	class Plane: Air {};
        
	class MIG29_Fulcrum: Plane
        {
		displayName="MIG-29 Fulcrum";
		weapons[]={MIG29_30mm, MIG29_AA8a_Aphid, kab500_mig};
		magazines[]={MIG29_30mm, MIG29_AA8a_Aphid, kab500_mig};
		model="\SPC_MIG\mig29.p3d";
		icon="\SPC_MIG\icon_mig29.paa";
		//threat[] VSoft, VArmor, VAir 
		threat[]={0.9, 1.0, 0.5};

		precision=200; // 200
		brakeDistance=100; // vehicle movement precision 500

		aileronSensitivity = 1.0; // relative aileron sensitivity 1
		elevatorSensitivity = 1.0; // relative elevator sensitivity 1
		noseDownCoef = 1.0; // how much goes nose down during turns 1
		landingAoa = 10*3.1415/180; // 10*3.1415/180

		scope=public;
		crew = "SoldierEPilot";
		picture = \SPC_MIG\imig29.paa;
		side = 0;
                camouflage=1;
                audible=5;
		accuracy=0.50;
		irTarget=1;
		irScanRange=15000;
		irScanGround=1;
		driverAction = ManActA10Pilot;
		cargoAction[]={"ManActCessnaCargo"};
		maxSpeed = 1250;		//Vmax=2500,Vstandart=1250,

		soundEngine[]={\SPC_MIG\MIG-29_Outside_Cruise_Flying.wav,db+40,1.0};
                soundDammage[]={"\SPC_MIG\AC_Caution.ogg",db+30,1};
		armor=20;
		cost=20000;
		transportSoldier=0;
		fov=0.5;
		type=VAir;

		class Reflectors
		{
			class Reflector
			{
				color[] = {0.9, 0.8, 0.8, 1.0};
				ambient[] = {0.1, 0.1, 0.1, 1.0};
				position = "L svetlo";
				direction = "konec L svetla";
				hitpoint = "L svetlo";
				selection = "L svetlo";
				size = 0.5;
				brightness = 0.25;
			};
		};

		class IndicatorAltRadar
		{
			// max for this indicator is 1000 feet (i.e. 304m)
			// note: this is actualy Baro altitude (name is wrong)
			selection = "alt";
			axis = "osa_alt";
			angle = -340;
			min = 0;
			max = 1000;
		};
		class IndicatorAltRadar2
		{
			// max for this indicator is 1000 feet (i.e. 304m)
			// note: this is actualy Baro altitude (name is wrong)
			selection = "alt2";
			axis = "osa_alt2";
			angle = -340;
			min = 0;
			max = 1000;
		};
		class IndicatorSpeed
		{
			selection = "mph";
			axis = "osa_mph";
			angle = -350;
			min = 0;
			max = 1000 / 3.6;
		};
		class IndicatorVertSpeed
		{
			selection = "vert_speed";
			axis = "osa_vert_speed";
			angle = -240;
			min = -150;
			max = 150;
		};
		class IndicatorVertSpeed2
		{
			selection = "vert_speed2";
			axis = "osa_vert_speed2";
			angle = -240;
			min = -150;
			max = 150;
		};
	};
};


class CfgNonAIVehicles
{
	class ProxyWeapon {};
	class ProxyMIG29_AA8a_Aphid : ProxyWeapon {model="\SPC_MIG\MIG29_AA8a_Aphid"; simulation = "maverickweapon";}
	
};

