[

// Language definitions for each side
// 		You can use any custom language you have defined below
// 		These options can be changed on a per mission basis by placing the corresponding game logics in the mission editor
// 		DEFAULT OPTIONS: english, russian, arabic
["WESTlang", "english"], // Language for west side
["EASTlang", "russian"], // Language for east side
["GUERlang", "english"], // Language for resistance side
["CIVlang", "english"], // Language for civilian side

// Frequency of AI speech
// 		OPTIONS: high, normal, low
["verbosity", "normal"],

// Max distance (in meters) from player or camera to activate AI speech
// 		Units beyond this distance won't play their speech sounds
["maxdist", 300],

// Player speech
// 		OPTIONS: sayAll, onlyWounded, none
// 		By using sayAll player characters will talk just like any other AI unit. Use none to mute them completely or onlyWounded to only say things started by eventhandlers (kill taunts, pain screams, etc)
["playerSpeech", "sayAll"],

// Name of the array containing all the units that will use DSAI
// 		Must be a string (it is CALLed later)
["unitsArray", "EXT_allUnits"],

// Name of the array containing all the groups that will use DSAI
// 		Must be a string (it is CALLed later)
// 		If you don't specify one (by setting it to "") then the groups array will be automatically created by the DSAI script
["groupsArray", "EXT_allGroups"],

// Particular units to be excluded from DSAI
// 		The majority of named units from the OFP campaigns are already excluded, so their speeches aren't interrumpted in cutscenes and the like
["excludedUnits", [
	// OFP campaigns named units
	david,velitel,tenhlevojak,straz1,straz2,ian,flakac1,serg,Peter,evans,bor,vojak,koz,fow,of,klikar,ian_2,cage,conery,of_1,of2,ian_3,hammer,blbec,blbec_1,sef,res1,res2,blake,ma1,ma2,ma3,ma4,ma5,guba,angel,rus,sab1,sab2,sab3,pilot,kamera,straz,sluha1,sluha2,sluha3,sluha4,ja,komparz,aP,soused,vesnican,p1,p2,off,volam,Viktor,ridic,gabe,ger,gabe2,ger2,viki,pp,pp_1,pp_2,pp_3,pp_4,pp_5,com1,com2,james,black,par,par1,par2,Stoyan,Victor,will,sold1,will2,cam1,suther,holer,carillo,gibbon,ltn,rto,posily,sedak,fowley,kozlowski,kaufman,sgt,soldier1,soldier2,oficer,hoch,v1,v1_1,v1_2,v1_3,v1_4,v1_5,v1_6,v1_7,v1_4_1,v1_3_1,v1_6_1,v1_1_1,v1_5_1,v1_2_1,h3,h5,man,zaj1,zaj2,zaj3,james2,rv4_1,rv5_1,rv6_1,rv7_1,rvsniper,rvsab,gas,ressniper,rv1,
	
	// Units just used to spawn other units
	CCE_DummyWest,CCE_DummyEast,CCE_DummyRes,CCE_DummyCiv,
	CP_spawner
] ],

// Particular groups to be excluded from DSAI
["excludedGroups", [
	
] ],

// Sides to be excluded from DSAI
["excludedSides", [
	sideEnemy,
	sideLogic
] ],

// Particular unit classes to be excluded from DSAI
// 		Place here unit types that should be silent by default. They will still use kill taunts and scream in pain, though. It already excludes vanilla, WW4 and WW4 Extended snipers, plus invisible units
["excludedUnitClasses", [
	// OFP snipers
	"SoldierWSniper","SoldierWLAWSniper","SoldierESniper","SoldierGSniper",
	
	// WW4 and WW4 Ext dummies
	"WW4_DummyWest","WW4_DummyEast","WW4_DummyRes","WW4_DummyCiv",
	"WW4EXT_spawnerWest","WW4EXT_spawnerEast","WW4EXT_spawnerGuer","WW4EXT_spawnerCiv",
	
	// WW4 Ext snipers & spotters
	"WW4EXT_AUSARSniper","WW4EXT_AUSARSpotter","WW4EXT_AUSARSniperGhi","WW4EXT_AUSARSpotterGhi","WW4EXT_ASPECOPSniper","WW4EXT_ASPECOPSpotter","WW4EXT_MSPECOPSniper","WW4EXT_MSPECOPSpotter","WW4EXT_SRSPECOPSniper","WW4EXT_SRSPECOPSpotter","WW4EXT_DCUUSARSniper","WW4EXT_DCUUSARSpotter","WW4EXT_DCUSPECOPSniper","WW4EXT_DCUSPECOPSpotter","WW4EXT_DMARSniper","WW4EXT_DMARSpotter","WW4EXT_DMARSniperGhi","WW4EXT_DMARSpotterGhi","WW4EXT_DFORECSniper","WW4EXT_DFORECSpotter","WW4EXT_DFORECSniperGreen","WW4EXT_DFORECSpotterGreen","WW4EXT_MARSniper","WW4EXT_MARSpotter","WW4EXT_MARSniperGhi","WW4EXT_MARSpotterGhi","WW4EXT_FORECSniper","WW4EXT_FORECSpotter","WW4EXT_FORECSniperGreen","WW4EXT_FORECSpotterGreen","WW4EXT_DFGRUSniper","WW4EXT_DFGRUSpotter","WW4EXT_DFGRUSniperVSS","WW4EXT_DGRUSniper","WW4EXT_DGRUSpotter","WW4EXT_DGRUSniperVSS","WW4EXT_CTSniper","WW4EXT_CTSpotter","WW4EXT_CTSniperVSS","WW4EXT_CTMSniper","WW4EXT_CTMSpotter","WW4EXT_CTMSniperVSS","WW4EXT_PTGRUSniper","WW4EXT_PTGRUSpotter","WW4EXT_PTGRUSniperVSS","WW4EXT_MERCSniperW","WW4EXT_MERCSniperE","WW4EXT_MERCSniper","WW4EXT_DMERCSniperW","WW4EXT_DMERCSniperE","WW4EXT_DMERCSniper","WW4EXT_INSSniper","WW4EXT_INSSniperW","WW4EXT_INSSniperE","WW4EXT_DINSSniper","WW4EXT_DINSSniperW","WW4EXT_DINSSniperE","WW4EXT_GUESniper","WW4EXT_GUESniperW","WW4EXT_GUESniperE","WW4EXT_DGUESniper","WW4EXT_DGUESniperW","WW4EXT_DGUESniperE","WW4EXT_MEINSSniper","WW4EXT_MEINSSniperW","WW4EXT_MEINSSniperE","WW4EXT_MEGUESniper","WW4EXT_MEGUESniperW","WW4EXT_MEGUESniperE","WW4EXT_INDYSniper","WW4EXT_INDYSniperW","WW4EXT_INDYSniperE","WW4EXT_DINDYSniper","WW4EXT_DINDYSniperW","WW4EXT_DINDYSniperE","WW4EXT_INDYSpotter","WW4EXT_INDYSpotterW","WW4EXT_INDYSpotterE","WW4EXT_DINDYSpotter","WW4EXT_DINDYSpotterW","WW4EXT_DINDYSpotterE","WW4EXT_MUSARSniper","WW4EXT_MUSARSpotter","WW4EXT_MUSARSniperGhi","WW4EXT_MUSARSpotterGhi","WW4EXT_BDUUSARSniperGhi","WW4EXT_BDUUSARSpotterGhi","WW4EXT_BDUSPECOPSniper","WW4EXT_BDUSPECOPSpotter","WW4EXT_DBDUUSARSniper","WW4EXT_DBDUUSARSpotter","WW4EXT_DBDUSPECOPSniper","WW4EXT_DBDUSPECOPSpotter","WW4EXT_SRBDUSPECOPSniper","WW4EXT_SRBDUSPECOPSpotter","WW4EXT_NIGHTSPECOPSniper","WW4EXT_NIGHTSPECOPSpotter","WW4EXT_GRUSniper","WW4EXT_GRUSpotter","WW4EXT_GRUSniperVSS","WW4EXT_AfGRUSniper","WW4EXT_AfGRUSpotter","WW4EXT_AfGRUSniperVSS","WW4EXT_GUECWSniper","WW4EXT_ARCTICUSARSPECOPSniper","WW4EXT_ARCTICUSARSPECOPSpotter","WW4EXT_ARCTICUSARSniper","WW4EXT_ARCTICUSARSpotter","WW4EXT_ARCTICGRUSniper","WW4EXT_ARCTICGRUSpotter","WW4EXT_ARCTICGRUSniperVSS","WW4EXT_ARCTIC_INSSniper","WW4EXT_ARCTIC_INSSniperW","WW4EXT_ARCTIC_INSSniperE","WW4EXT_ARCTIC_GUESniper","WW4EXT_ARCTIC_GUESniperW","WW4EXT_ARCTIC_GUESniperE","WW4EXT_INDYTROPSniper","WW4EXT_INDYTROPSniperW","WW4EXT_INDYTROPSniperE","WW4EXT_TROPICAL_INSSniper","WW4EXT_TROPICAL_INSSniperW","WW4EXT_TROPICAL_INSSniperE","WW4EXT_TROPICAL_GUESniper","WW4EXT_TROPICAL_GUESniperW","WW4EXT_TROPICAL_GUESniperE","WW4EXT_MOTSniperGhi","WW4EXT_MOTSniperGhiVSS","WW4EXT_MOTSpotterGhi","WW4EXT_MOTSpotterGhiSD","WW4EXT_DFMOTSniperGhi","WW4EXT_DFMOTSniperGhiVSS","WW4EXT_DFMOTSpotterGhi","WW4EXT_DFMOTSpotterGhiSD","WW4EXT_GRUSniperGhi","WW4EXT_GRUSniperGhiVSS","WW4EXT_GRUSpotterGhi"
] ],

// List of women classes
// 		This will allow EXT_DSAI to use female voices (if available) for these types of units
["womenClasses", [
	// OFP women
	"Angelina","Woman1","Woman2","Woman3","Woman4","Woman5",
	
	// BAS women
	"BAS_opforciv1w","BAS_opforciv2w","BAS_opforciv3w","BAS_opforciv1wRES","BAS_opforciv2wRES","BAS_opforciv3wRES","BAS_opforciv1wE","BAS_opforciv2wE","BAS_opforciv3wE","BAS_MilitiaWAKM","BAS_MilitiaWSKS","BAS_MilitiaWFAL","BAS_MilitiaWG3","BAS_MilitiaWRPD","BAS_MilitiaWPKM","BAS_MilitiaWSVD","BAS_MilitiaWRPG","BAS_MilitiaWRPGAA","BAS_MilitiaWRPGAP","BAS_MilitiaWAKMHD","BAS_MilitiaWSKSHD","BAS_MilitiaWFALHD","BAS_MilitiaWG3HD","BAS_MilitiaWRPDHD","BAS_MilitiaWPKMHD","BAS_MilitiaWRPGHD","BAS_MilitiaWRPGAAHD","BAS_MilitiaWRPGAPHD",
	
	// DMA women
	"dma_lib_civf1","dma_lib_civf2","dma_lib_civf3","dma_lib_civf4",
	
	// WW4 Ext women
	"WW4EXT_BISCIVWoman01","WW4EXT_BISCIVWoman02","WW4EXT_BISCIVWoman03","WW4EXT_BISCIVWoman04","WW4EXT_BISCIVWoman05",
	"WW4EXT_ARCTIC_INSRiflemanFem","WW4EXT_ARCTIC_INSRiflemanFemW","WW4EXT_ARCTIC_INSRiflemanFemE","WW4EXT_ARCTIC_CivFem1","WW4EXT_ARCTIC_CivFem2","WW4EXT_ARCTIC_CivFem3","WW4EXT_ARCTIC_CivFem4","WW4EXT_ARCTIC_CivFem5","WW4EXT_ARCTIC_CivFem6"
] ],

// List of MG and LMG classes
// 		Units only warn about reloading their weapons if it's listed here
["MGs", [
	// OFP MGs
	"PK","M60",
	
	// WW4 and WW4 Ext MGs
	"WW4_M240","WW4_M60","WW4_M249","WW4_M249Aim",
	"WW4_PKM","WW4_RPK74","WW4_RPK74Kobra","WW4_RPK47",
	"WW4EXT_M240","WW4EXT_M60","WW4EXT_M249","WW4EXT_M249Aim","WW4EXT_M16A1AR",
	"WW4EXT_PKM","WW4EXT_RPK74","WW4EXT_RPK74M","WW4EXT_RPK74MKobra","WW4EXT_RPK47"
] ],

// List of sniper rifle classes
// 		If the killer uses one of these rifles one of the teammates of the victim will alert about the sniper
["sniperrifles", [
	// OFP sniper rifles
	"M21","SVDDragunov","HuntingRifle",
	
	// WW4 and WW4 Ext sniper rifles
	"WW4_M82","WW4_VSS","WW4_SVD","WW4_V94","WW4_M24","WW4_SR25SD","WW4_M21","WW4_M40",
	"WW4EXT_M82","WW4EXT_VSS","WW4EXT_SVD","WW4EXT_V94","WW4EXT_M24","WW4EXT_SR25SD","WW4EXT_M21","WW4EXT_M40","WW4EXT_HuntingRifle"
] ],

// List of hand grenade classes
// 		Units throwing grenades have a chance of warning teammates as long as the one used is listed here
["handgrenades", [
	// OFP hand grenades
	"GrenadeHand",
	
	// WGL hand grenades
	"WGL_Handgrenade",
	
	// WW4 Ext hand grenades
	"WW4EXT_HandGrenade","WW4EXT_M26","WW4EXT_M67","WW4EXT_RGN","WW4EXT_RGO","WW4EXT_RGD5","WW4EXT_F1"
] ],

// List of smoke grenade classes
// 		Units throwing smoke grenades have a chance of warning teammates as long as the one used is listed here
["smokegrenades", [
	// OFP smoke grenades
	"SmokeShell","SmokeShellGreen","SmokeShellRed"
] ],

// Generic start of day and night
// 		This value is used in order to use whisper versions of AI speech (if available) during nighttime
["nightStart", 22],
["nightEnd", 4],

// Facial expressions
// 		Enables different facial expressions depending on what AI units are saying
["facialExpressions", true], 

// Enable debugging messages
["debug", false]

]

// Load default languages
// 		Development version
/*
+ (call preprocessfile "..\@extfx_DEV\EXT_DSAI_lang\english.sqf")
+ (call preprocessfile "..\@extfx_DEV\EXT_DSAI_lang\russian.sqf")
+ (call preprocessfile "..\@extfx_DEV\EXT_DSAI_lang\arabic.sqf")
*/
// 		Development version (ECP) ** Requires ECP_DSAI.pbo **
//+ (call preprocessfile "..\@extfx_DEV\EXT_DSAI_lang\english_ECP.sqf")
//+ (call preprocessfile "..\@extfx_DEV\EXT_DSAI_lang\russian_ECP.sqf")


// 		Release version
+ (call preprocessfile "..\@extfx\EXT_DSAI_lang\english.sqf")
+ (call preprocessfile "..\@extfx\EXT_DSAI_lang\russian.sqf")
+ (call preprocessfile "..\@extfx\EXT_DSAI_lang\arabic.sqf")
/*
// 		Release version (ECP) ** Requires ECP_DSAI.pbo **
+ (call preprocessfile "..\@extfx\EXT_DSAI_lang\english_ECP.sqf")
+ (call preprocessfile "..\@extfx\EXT_DSAI_lang\russian_ECP.sqf")
*/

// Load custom languages
// Example:
// + (call preprocessfile "..\@extfx\EXT_DSAI_lang\klingon.sqf")
