[

// *** GLOBAL FEATURES ***

/*
UNIT VARIABLES
Periodically checks and saves several status and contextual information for each unit present in a mission.

It's inspired by and behaves similarly (to some extent) to the getVariable and setVariable commands that can be found in later Armas.

Among other things, it keeps track of:
	* If unit feels in danger (if it detects a hostile unit nearby) 
	* Time of the last contact with enemy units
	* Whether if it's in water, in a forest or on a road
	* The nearest object, building, infantry unit or corpse
	* Its current stance (prone, standing, crouching...)

The data stored is used by several other features.
		
In order to keep performance as high as possible it uses a single script that iterates through all the units present on the mission.
This means that the more units present the longer it will take for each check. This time will also increase on terrains or missions with lots of objects (bushes, trees, buildings, etc).

It can have a hit on performance, particularly when the object count is high, so you might want to disable it depending on your system specs.

WARNING: Disabling unit variables WILL ALSO DISABLE other features, regardless of their particular settings:
	* Dynamic Soundscape
	* Fallen trees being able to provide concealment
	* Dynamic stance for AI units (AI units won't crouch near sandbags, etc)
	
Other features not on the list above will use alternative means to retrieve the information usually gathered by unitvars, so they will still work more or less as expected.

!!! Even when disabled, unitvars will still save the "initialized" parameter for each infantry unit. This is needed to avoid running their init script more than once when entering and exiting vehicles.
*/

["unitvars", true], // (default: true) 

/*		
DYNAMIC SPEECH FOR AI
You can finetune its settings by editing the EXT_DSAI_settings.sqf file
*/

["DSAI", true], // (default: true) 

/*	
DYNAMIC SOUNDSCAPE
You can finetune its settings by editing the EXT_dynsound_settings.sqf file
*/

["DynSound", true], // (default: true) 


// *** INDIVIDUAL EFFECTS ***
// 		These effects can be superseded on a per mission basis by placing the corresponding game logics in the mission editor

// 	Basic features
// 		These options enhance vanilla gameplay with several effects and some slight gameplay enhancements
["tracers", true], // (default: true) More realistic looking tracers for machineguns (for infantry and vehicles)
["bulletcrack", true], // (default: true) Bullet cracks
["wpndustfx", true], // (default: true) Dust effects for weapons (shooting, hit, rocket launchers...)
["unitdustfx", true], // (default: true) Dust effects for units (dust trail for vehicles and infantry and rotor wash for helicopters)
["contextstance", true], // (default: true) Contextual stance for AI (AI units will crouch behind sandbags, etc)
["throwsmoke", true], // (default: true) AI units equipped with smoke grenades will have a chance to throw one when hit
["blocksmoke", true], // (default: true) Smoke grenades will provide concealment from AI
["blockfallentree", true], // (default: true) Fallen trees will provide concealment from AI
["extendedflares", true], // (default: true) Flares will descend more slowly and will be visible during daytime
["jetflyby", true], // (default: true) Flyby sounds for jet planes

// 	Advanced features
// 		These options change vanilla gameplay to a higher degree or might affect performance
["bouncygrenades", true], // (default: false) Hand grenades will explode after about 4 seconds instead of on contact. They will bounce over any surface they contact before exploding
["hitfx", true], // (default: false) Units hit by bullets or other damage sources will lie down and/or flinch. Players will see a white flash every time they are hit
["suppression", true], // (default: false) Places an invisible target over a hit infantry unit, so enemy AI has a chance to suppress that area
["activeprot", true], // (default: false) Active protection for vehicles (automatic flare launching for air units. It also activates Shtora for some modern russian tanks found in WW4 Extended)
["shotreverb", true], // (default: false) Rifle shots will reverberate when fired inside buildings

// 	WW4 Extended models features
// 		Only available in the WW4Ext module (@extfx_WW4Ext)
["tankgunrecoil", true], // (default: true) Recoil animation for tank barrels


// *** WW4 EXTENDED EFFECTS ***
// 		These effects will only have effect on the WW4 Extended mod (the main one, not @extfx_WW4Ext)
// 		These effects can be superseeded on a per mission basis by placing the corresponding game logics in the mission editor

["noEH", false], // Disable any effect activated by eventhandlers (it's automatically set to false if any other of the features below is on)

// 		Infantry
["launchers", false], // Disposable launchers will be deleted after being fired
["nofaces", false], // No custom faces (arab, camouflage, etc)
["deletebodies", false], // Automatically delete corpses after 5 minutes
["removepistols", false], // Remove handguns from all infantry units
["hdWEST", false], // High dispersion ammo for all west infantry units
["hdEAST", false], // High dispersion ammo for all east infantry units
["hdGUER", false], // High dispersion ammo for all resistance infantry units

// 		Rucksacks
["rucksackPlayers", false], // Equip players with rucksacks
["rucksackAI", false], // Equip AI units with rucksacks, giving them the ability to use them to replenish ammo or share it with other teammates
["invisruck", false], // Equipped rucksacks will be invisible

// 		Vehicles
["limitedSpeed", false], // Limited speed for aircraft when using LIMITED speed in a wapoint

// 		Wind
["wind", false], // Measure wind direction and speed
["rpgdeviate", false], // RPG-7 trajectory affected by wind


["debug", false] // Debugging messages

];