@echo off
cls
echo.

If exist newdata\jasno.pac goto ok1
echo Installfiles not found.
goto end

:ok1
If not exist ..\res\dta\data.pbo echo ERROR data.pbo not found
If not exist ..\res\dta\data.pbo goto end

If not exist ..\res\dta\data3d.pbo echo ERROR data3d.pbo not found
If not exist ..\res\dta\data3d.pbo goto end

If not exist ..\res\dta\hwtl\data.pbo echo ERROR hwtl/data.pbo not found
If not exist ..\res\dta\hwtl\data.pbo goto end

If not exist ..\res\dta\hwtl\data3d.pbo echo ERROR hwtl/data3d.pbo not found
If not exist ..\res\dta\hwtl\data3d.pbo goto end

echo This will process datafiles as required for high resolution skies.
echo None of the original OFP files will be modified.
echo.
echo Before proceeding, please make sure that you have
echo at least 400MB free space on this drive.
echo.
echo.

echo Press any key to continue or ctrl-c to abort.
pause >NUL

mkdir dta
mkdir dta\hwtl
mkdir temp
del /Q temp\*.* >NUL

cls
echo Processing dta\data.pbo...
echo.

bin\cpbo.exe -e ..\res\dta\data.pbo temp
copy /Y newdata\*.pa? temp\ >NUL
bin\cpbo.exe -p temp dta\data.pbo
del /Q temp\*.* >NUL

cls
echo Processing dta\hwtl\data.pbo...
echo.

bin\cpbo.exe -e ..\res\dta\hwtl\data.pbo temp
copy /Y newdata\*.pa? temp\ >NUL
bin\cpbo.exe -p temp dta\hwtl\data.pbo
del /Q temp\*.* >NUL

cls
echo Processing dta\data3d.pbo...
echo.

bin\cpbo.exe -e ..\res\dta\data3d.pbo temp
del /Q temp\obloha.p3d.srpc >NUL
copy /Y newdata\obloha.p3d temp\ >NUL
bin\cpbo.exe -p temp dta\data3d.pbo
del /Q temp\*.* >NUL

cls
echo Processing dta\hwtl\data3d.pbo...
echo.

bin\cpbo.exe -e ..\res\dta\hwtl\data3d.pbo temp
del /Q temp\obloha.p3d.srpc >NUL
copy /Y newdata\obloha.p3d temp\ >NUL
bin\cpbo.exe -p temp dta\hwtl\data3d.pbo
del /Q temp\*.* >NUL

cls
echo.
echo all done.
echo You can now run OFP with high resolution skies by using -mod=hisky parameter.

:end
pause
